/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MainMenuHandler
extends MenuHandlerBase {
    private final RenderSkybox panorama = new RenderSkybox(new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama")));
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_TITLE_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private static final Random RANDOM = new Random();
    private String splash;

    public MainMenuHandler() {
        super(MainMenuScreen.class.getName());
    }

    @Override
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        this.splash = MainMenuHandler.getRandomSplashText();
    }

    @Override
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui()) && e.getGui() instanceof MainMenuScreen) {
            MainMenuHandler.setShowFadeInAnimation(false, (MainMenuScreen)e.getGui());
        }
        super.onInitPre(e);
    }

    @Override
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            if (this.splash == null) {
                this.splash = MainMenuHandler.getRandomSplashText();
            }
            this.setWidthCopyrightRest(Integer.MAX_VALUE);
            super.onButtonsCached(e);
        }
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            e.setCanceled(true);
            e.getGui().func_230446_a_(e.getMatrixStack());
        }
    }

    @Override
    public void drawToBackground(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (this.shouldCustomize(e.getGui())) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int width = e.getGui().field_230708_k_;
            int height = e.getGui().field_230709_l_;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            MatrixStack matrix = CurrentScreenHandler.getMatrixStack();
            RenderSystem.enableBlend();
            if (!this.canRenderBackground()) {
                this.panorama.func_217623_a(Minecraft.func_71410_x().func_184121_ak(), 1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/title/background/panorama_overlay.png"));
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IngameGui.func_238466_a_((MatrixStack)matrix, (int)0, (int)0, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            }
            super.drawToBackground(e);
            if (!((Boolean)FancyMenu.config.getOrDefault("hidelogo", (Object)true)).booleanValue()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((double)minecraftLogoSpelling < 1.0E-4) {
                    e.getGui().func_238474_b_(matrix, j + 0, 30, 0, 0, 99, 44);
                    e.getGui().func_238474_b_(matrix, j + 99, 30, 129, 0, 27, 44);
                    e.getGui().func_238474_b_(matrix, j + 99 + 26, 30, 126, 0, 3, 44);
                    e.getGui().func_238474_b_(matrix, j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                    e.getGui().func_238474_b_(matrix, j + 155, 30, 0, 45, 155, 44);
                } else {
                    e.getGui().func_238474_b_(matrix, j + 0, 30, 0, 0, 155, 44);
                    e.getGui().func_238474_b_(matrix, j + 155, 30, 0, 45, 155, 44);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_EDITION);
                IngameGui.func_238463_a_((MatrixStack)matrix, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hidebranding", (Object)true)).booleanValue()) {
                e.getGui();
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                    int n = e.getGui().field_230709_l_;
                    int n2 = brdline;
                    font.getClass();
                    AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)brd, (int)2, (int)(n - (10 + n2 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hideforgenotifications", (Object)false)).booleanValue()) {
                ForgeHooksClient.renderMainMenu((MainMenuScreen)((MainMenuScreen)e.getGui()), (MatrixStack)matrix, (FontRenderer)font, (int)width, (int)height);
                e.getGui();
                BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                    int n = e.getGui().field_230708_k_ - font.func_78256_a(brd) - 1;
                    int n2 = e.getGui().field_230709_l_;
                    int n3 = brdline + 1;
                    font.getClass();
                    AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)brd, (int)n, (int)(n2 - (11 + n3 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            String c = "Copyright Mojang AB. Do not distribute!";
            String cPos = (String)FancyMenu.config.getOrDefault("copyrightposition", (Object)"bottom-right");
            int cX = 0;
            int cY = 0;
            int cW = Minecraft.func_71410_x().field_71466_p.func_78256_a(c);
            int cH = 10;
            if (cPos.equalsIgnoreCase("top-left")) {
                cX = 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-centered")) {
                cX = width / 2 - cW / 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-right")) {
                cX = width - cW - 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("bottom-left")) {
                cX = 2;
                cY = height - cH - 2;
            } else if (cPos.equalsIgnoreCase("bottom-centered")) {
                cX = width / 2 - cW / 2;
                cY = height - cH - 2;
            } else {
                cX = width - cW - 2;
                cY = height - cH - 2;
            }
            Color copyrightcolor = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("copyrightcolor", (Object)"#ffffff")));
            if (copyrightcolor == null) {
                copyrightcolor = new Color(255, 255, 255);
            }
            AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)c, (int)cX, (int)cY, (int)(copyrightcolor.getRGB() | 0xFF000000));
            if (mouseX >= cX && mouseX <= cX + cW && mouseY >= cY && mouseY <= cY + cH) {
                IngameGui.func_238467_a_((MatrixStack)matrix, (int)cX, (int)(cY + cH - 1), (int)(cX + cW), (int)(cY + cH), (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new WinGameScreen(false, Runnables.doNothing()));
                }
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtons(e, mouseX, mouseY);
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hiderealmsnotifications", (Object)false)).booleanValue()) {
                this.drawRealmsNotification(matrix, e.getGui());
            }
            this.renderSplash(matrix, font, e.getGui());
        }
    }

    protected void renderSplash(MatrixStack matrix, FontRenderer font, Screen s) {
        if (!((Boolean)FancyMenu.config.getOrDefault("hidesplashtext", (Object)true)).booleanValue()) {
            float finalPosX = s.field_230708_k_ / 2 + 90;
            float finalPosY = 70.0f;
            int rotation = (Integer)FancyMenu.config.getOrDefault("splashrotation", (Object)-20);
            int posX = (Integer)FancyMenu.config.getOrDefault("splashx", (Object)0);
            int posY = (Integer)FancyMenu.config.getOrDefault("splashy", (Object)0);
            String orientation = (String)FancyMenu.config.getOrDefault("splashorientation", (Object)"original");
            int originX = 0;
            int originY = 0;
            boolean setpos = true;
            if (orientation.equalsIgnoreCase("original")) {
                originX = (int)finalPosX;
                originY = (int)finalPosY;
            } else if (!orientation.equalsIgnoreCase("top-left")) {
                if (orientation.equalsIgnoreCase("mid-left")) {
                    originY = s.field_230709_l_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-left")) {
                    originY = s.field_230709_l_;
                } else if (orientation.equalsIgnoreCase("top-centered")) {
                    originX = s.field_230708_k_ / 2;
                } else if (orientation.equalsIgnoreCase("mid-centered")) {
                    originX = s.field_230708_k_ / 2;
                    originY = s.field_230709_l_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-centered")) {
                    originX = s.field_230708_k_ / 2;
                    originY = s.field_230709_l_;
                } else if (orientation.equalsIgnoreCase("top-right")) {
                    originX = s.field_230708_k_;
                } else if (orientation.equalsIgnoreCase("mid-right")) {
                    originX = s.field_230708_k_;
                    originY = s.field_230709_l_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-right")) {
                    originX = s.field_230708_k_;
                    originY = s.field_230709_l_;
                } else {
                    setpos = false;
                }
            }
            if (setpos) {
                finalPosX = originX + posX;
                finalPosY = originY + posY;
            }
            if (this.splash == null) {
                this.splash = "";
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)finalPosX, (float)finalPosY, (float)0.0f);
            RenderSystem.rotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            float f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            f = f * 100.0f / (float)(font.func_78256_a(this.splash) + 32);
            RenderSystem.scalef((float)f, (float)f, (float)f);
            Color c = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("splashcolor", (Object)"#ffff00")));
            if (c == null) {
                c = new Color(255, 255, 0);
            }
            AbstractGui.func_238472_a_((MatrixStack)matrix, (FontRenderer)font, (ITextComponent)new StringTextComponent(this.splash), (int)0, (int)-8, (int)c.getRGB());
            RenderSystem.popMatrix();
        }
    }

    private void renderButtons(GuiScreenEvent.BackgroundDrawnEvent e, int mouseX, int mouseY) {
        List<Widget> buttons = this.getButtonList(e.getGui());
        float partial = Minecraft.func_71410_x().func_184121_ak();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                buttons.get(i).func_230430_a_(CurrentScreenHandler.getMatrixStack(), mouseX, mouseY, partial);
            }
        }
    }

    private void drawRealmsNotification(MatrixStack matrix, Screen gui) {
        if (Minecraft.func_71410_x().field_71474_y.field_183509_X) {
            Field f = ObfuscationReflectionHelper.findField(MainMenuScreen.class, (String)"field_183503_M");
            Screen realms = null;
            try {
                realms = (Screen)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realms != null) {
                realms.func_230430_a_(matrix, (int)Minecraft.func_71410_x().field_71417_B.func_198024_e(), (int)Minecraft.func_71410_x().field_71417_B.func_198026_f(), Minecraft.func_71410_x().func_184121_ak());
            }
        }
    }

    private List<Widget> getButtonList(Screen gui) {
        Field f = ObfuscationReflectionHelper.findField(Screen.class, (String)"field_230710_m_");
        ArrayList<Widget> buttons = new ArrayList();
        try {
            buttons = (List)f.get(gui);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }

    private void setWidthCopyrightRest(int i) {
        try {
            if (Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen) {
                Field f = ObfuscationReflectionHelper.findField(MainMenuScreen.class, (String)"field_193979_N");
                f.set(Minecraft.func_71410_x().field_71462_r, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void setShowFadeInAnimation(boolean showFadeIn, MainMenuScreen s) {
        try {
            Field f = ObfuscationReflectionHelper.findField(MainMenuScreen.class, (String)"field_213102_y");
            f.setBoolean(s, showFadeIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String getRandomSplashText() {
        List l;
        File f;
        String customSplashPath = (String)FancyMenu.config.getOrDefault("splashtextfile", (Object)"");
        if (customSplashPath != null && !customSplashPath.equals("") && (f = new File(customSplashPath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
            int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
            return (String)l.get(random);
        }
        return Minecraft.func_71410_x().func_213269_at().func_215276_a();
    }
}

